﻿<?php
require 'include/empresa.php';
require 'include/formulario.php';
require 'include/cliente.php';
require 'include/horas.php';
require_once 'dompdf/dompdf_config.inc.php';

ob_start();
?>
<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
		<title>Estado de Cuenta por Cliente</title>
		
		<link href="css/reportes.css" rel="stylesheet">

		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		  <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<!--<base href="localhost/reportes">-->
	</head>
	<body>
		<div class="wrap">
			<?
				if(isset($_GET['imprimir'])){ 
					$idcliente = $_GET['cliente'];
					$desde = $_GET['desde'];
					$hasta = $_GET['hasta'];
					$hmantenimiento = array();
					$hgarantia = array();
					$htotal = array();
					$formularios = Formulario::getEstadocuenta($idcliente, $desde, $hasta);
			?>
			<div id="encabezado">
				<img src="http://represensa.com/images/lucas-logo.jpg" width="280px"/>
				<p><?php setlocale(LC_TIME, 'spanish'); echo 'Guayaquil, '.strftime("%d de %B del %Y");?></p>
				<div id="titulos">
				<h2>Estado de Cuenta</h2>
				<h2 style="text-transform: uppercase;"><?php echo(Empresa::getNombre($idcliente));?></h2>
				<p>Desde: <?php echo($desde);?> Hasta: <?php echo($hasta);?></p>
				</div>
				<div id="texto-encabezado">
				<br/>
				<p>Estimado cliente: <br/>Nos permitimos presentarle a continuación el detalle de las horas atendidas por Mantenimiento, las mismas que son:</p>
				</div>
			</div>
			<div id="reporte">
				<div id="formularios">
					<table class="conborde">
						<thead>
							<tr>
								<th>ID FORM.</th><th>REQUERIMIENTOS</th><th>FECHA SOLUCIÓN</th><th>HORAS DESARROLLO</th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach($formularios as $formulario){
								array_push($htotal, $formulario['tiempo_facturado']);
								if ($formulario["clasificacion_requerimiento"]==7){
									array_push($hgarantia, $formulario['tiempo_facturado']);
								}else{
									array_push($hmantenimiento, $formulario['tiempo_facturado']);
								} 
							?>
								<tr>
									<td style="text-align: center;">
										<?php
											if ($formulario["clasificacion_requerimiento"]==7){
												echo "*";
											} 
											echo($formulario['id_formulario']);
										?>
									</td>
									<td>
										<? 
											echo($formulario['requerimiento']);
										?>
									</td>
									<td style="text-align: center;">
										<? 
											echo($formulario['fecha_solucion']); 
										?>
									</td>
									<td style="text-align: center;">
										<?
											echo(substr($formulario['tiempo_facturado'],0,5));
										?>
									</td>
								</tr>
							<?}?>
								<tr>
									<td colspan="3" style="text-align:right;"><b>Total Horas Atendidas:</b></td>
									<td style="text-align:center;"><b><? echo(Horas::Sumar($htotal));?></b></td>
								</tr>
								<tr>
									<td colspan="4" style="border: none;"><b>* Requerimientos tipo garantía.</b></td>
								</tr>
						</tbody>
					</table>
				</div>
				<div id="horas">
					<table class="conborde">
						<tbody>
							<tr>
								<td>Horas contratadas:</td>
								<td>
									<?php
										$cupo = Cliente::getCupoHoras($idcliente);
										$hcupo = $cupo[0]['cupo_horas'].":00";
										echo($hcupo);
									?>
								</td>
							</tr>
							<tr>
								<td>
									Horas atendidas mantenimiento:
								</td>
								<td>
									<?
										$hmant = Horas::Sumar($hmantenimiento);
										echo($hmant);
									?>
								</td>
							</tr>
							<tr>
								<td>
									Horas atendidas garantía:
								</td>
								<td>
									<?
										echo(Horas::Sumar($hgarantia));
									?>
								</td>
							</tr>
							<tr>
								<td>
									Horas adicionales:
								</td>
								<td>
									<?
										$horas = Horas::Adicionales($hmant, $hcupo);
										echo($horas['adicionales']);
									?>
								</td>
							</tr>
							<tr>
								<td>
									Horas pendientes de atención:
								</td>
								<td>
									<?
										echo($horas['pendientes']);
									?>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<?
					}
			?>
				<div id="pie-reporte">
					<p>Con el detalle antes presentado, quedan justificadas las horas desde: <?php echo($desde);?> hasta: <?php echo($hasta);?>.</p>
					<p>Por lo expuesto suscriben los responsables su aceptación.</p>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>
					<br/>
					<table id="firmas" class="sinborde">
						<tr style="text-decoration: underline;">
							<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
							<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
						</tr>
						<tr>
							<td><b>Dpto. de Sistemas<br/>LUCAS IT</b></td>
							<td><b><?php echo(Empresa::getNombre($idcliente));?><br/>Aceptado - Recibido</b></td>
						</tr>
					</table>
				</div>
			</div>
		</div>
  </body>
</html>

<?php
$html = ob_get_clean();
$dompdf = new DOMPDF();
$dompdf->load_html($html);
$dompdf->render();
$dompdf->stream("estado_cuenta.pdf", array('Attachment' => '0'));
?>